<?php if (!defined('WPO_VERSION'))  die('No direct access allowed'); ?>
<div class="wpo_section wpo_group">
	<form id="wpo_minify_settings_form">
		<div id="wpo_settings_warnings"></div>
	
		<h3><?php esc_html_e('Miscellaneous', 'wp-optimize'); ?></h3>
		<div class="wpo-fieldgroup">
			<fieldset>
				<div class="wpo-fieldgroup__subgroup">
					<label for="merge_inline_extra_css_js">
						<input
							name="merge_inline_extra_css_js"
							type="checkbox"
							id="merge_inline_extra_css_js"
							value="1"
							<?php echo checked($wpo_minify_options['merge_inline_extra_css_js']);?>
						>
						<?php esc_html_e('Merge inline extra css and javascript', 'wp-optimize'); ?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('Inline JavaScript and CSS that should come before or after other enqueued files will be merged.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
				<div class="wpo-fieldgroup__subgroup">
					<label for="disable_when_logged_in">
						<input
							name="disable_when_logged_in"
							type="checkbox"
							id="disable_when_logged_in"
							value="1"
							<?php echo checked($wpo_minify_options['disable_when_logged_in']);?>
						>
						<?php esc_html_e('Disable Minify for logged-in users', 'wp-optimize'); ?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('HTML, JavaScript and CSS will be loaded normally by WordPress.', 'wp-optimize');?> <?php esc_attr_e('Useful for debugging or to improve compatibility with some visual editors.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
				<div class="wpo-fieldgroup__subgroup">
					<label for="clean_header_one">
						<input
							name="clean_header_one"
							type="checkbox"
							id="clean_header_one"
							value="1"
							<?php echo checked($wpo_minify_options['clean_header_one']); ?>
						>
						<?php esc_html_e('Remove meta information from page header', 'wp-optimize'); ?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('Remove resource hints, generator tag, shortlinks, manifest link, etc.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
				<div class="wpo-fieldgroup__subgroup">
					<label for="emoji_removal">
						<input
							name="emoji_removal"
							type="checkbox"
							id="emoji_removal"
							class="jsprocessor"
							value="1"
							<?php echo checked($wpo_minify_options['emoji_removal']); ?>
						>
						<?php esc_html_e('Remove default WordPress and TinyMCE icons', 'wp-optimize'); ?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('When selected, the site will use the device\'s built in Emoji', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
			</fieldset>
		</div>

		<h3><?php esc_html_e('SSL options', 'wp-optimize'); ?></h3>
		<div class="wpo-fieldgroup">
			<p class="wpo_min-bold-green wpo_min-rowintro">
				<?php esc_html_e('Force HTTP or HTTPS on the assets generated by WP-Optimize Minify.', 'wp-optimize'); ?>
				<?php esc_html_e('You may need it for some CDN plugins to work:', 'wp-optimize'); ?>
			</p>
			<fieldset>
				<div class="wpo-fieldgroup__subgroup">
					<label>
						<input
							type="radio"
							name="default_protocol"
							value="dynamic"
							<?php checked('dynamic' === $wpo_minify_options['default_protocol']); ?>
						>
					<?php
						esc_html_e('Same as home URL', 'wp-optimize');
						echo '(';
						// translators: %s is the current HTTP protocol
						printf(esc_html__('Currently: %s', 'wp-optimize'), esc_html($default_protocol));
						echo ')';
					?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('Uses your site\'s default protocol.', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
				<div class="wpo-fieldgroup__subgroup">
					<label>
						<input
							type="radio"
							name="default_protocol"
							value="http"
							<?php checked('http' === $wpo_minify_options['default_protocol']); ?>
						>
						<?php esc_html_e('Force HTTP', 'wp-optimize'); ?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('If you do not have SSL', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
				<div class="wpo-fieldgroup__subgroup">
					<label>
						<input
							type="radio"
							name="default_protocol"
							value="https"
							<?php checked('https' === $wpo_minify_options['default_protocol']); ?>
						>
						<?php esc_html_e('Force HTTPS', 'wp-optimize'); ?>
					</label>
					<span tabindex="0" data-tooltip="<?php esc_attr_e('Recommended if you have SSL', 'wp-optimize');?>"><span class="dashicons dashicons-editor-help"></span></span><br>
				</div>
			</fieldset>
		</div>

		<?php
		/**
		 * Called before outputting the submit button in the setting fields in Minify > Advanced
		 */
		do_action('wpo_minify_settings_tabs', $wpo_minify_options);
		?>

		<p class="submit">
			<input
				class="wp-optimize-save-minify-settings button button-primary"
				type="submit"
				value="<?php esc_attr_e('Save settings', 'wp-optimize'); ?>"
			>
			<img class="wpo_spinner" src="<?php echo esc_url(admin_url('images/spinner-2x.gif')); // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage -- N/A ?>" alt="...">
			<span class="save-done dashicons dashicons-yes display-none"></span>
		</p>
	</form>
</div>
